# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 662-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53523);
 script_cve_id("CVE-2005-0104", "CVE-2005-0152");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 662-2 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 662-2.

Andrew Archibald discovered that the last update to squirrelmail which
was intended to fix several problems caused a regression which got
exposed when the user hits a session timeout.  For completeness below
is the original advisory text:

Several vulnerabilities have been discovered in Squirrelmail, a
commonly used webmail system.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-0104

Upstream developers noticed that an unsanitised variable could
lead to cross site scripting.

CVE-2005-0152

Grant Hollingworth discovered that under certain circumstances URL
manipulation could lead to the execution of arbitrary code with
the privileges of www-data.  This problem only exists in version
1.2.6 of Squirrelmail.

For the stable distribution (woody) these problems have been fixed in
version 1.2.6-3.

The correction in the unstable distribution (sid) is not affected by
this regression.

We recommend that you upgrade your squirrelmail package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20662-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 662-2 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
