# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 701-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53540);
 script_bugtraq_id(11973);
 script_cve_id("CVE-2004-1154");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 701-2 (samba)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to samba
announced via advisory DSA 701-2.

It has been discovered that the last security update for Samba, a
LanManager like file and printer server for GNU/Linux and Unix-like
systems caused the daemon to crash upon reload.  This has been fixed.
For reference below is the original advisory text:

Greg MacManus discovered an integer overflow in the smb daemon from
Samba, a LanManager like file and printer server for GNU/Linux and
Unix-like systems.  Requesting a very large number of access control
descriptors from the server could exploit the integer overflow, which
may result in a buffer overflow which could lead to the execution of
arbitrary code with root privileges.  Upstream developers have
discovered more possible integer overflows that are fixed with this
update as well.

For the stable distribution (woody) these problems have been fixed in
version 2.2.3a-15.

The version in the unstable distribution (sid) is not affected by this
new problem.

We recommend that you upgrade your samba packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20701-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 701-2 (samba)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"2.2.3a-15", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
