# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 769-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54455);
 script_cve_id("CVE-2005-2370");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 769-1 (gaim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gaim
announced via advisory DSA 769-1.

Szymon Zygmunt and Michal Bartoszkiewicz discovered a memory alignment
error in libgadu (from ekg, console Gadu Gadu client, an instant
messaging program) which is included in gaim, a multi-protocol instant
messaging client, as well.  This can not be exploited on the x86
architecture but on others, e.g. on Sparc and lead to a bus error,
in other words a denial of service.

The old stable distribution (woody) does not seem to be affected by
this problem.

For the stable distribution (sarge) this problem has been fixed in
version 1.2.1-1.4.

For the unstable distribution (sid) this problem will be fixed soon.

We recommend that you upgrade your gaim package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20769-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 769-1 (gaim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gaim-data", ver:"1.2.1-1.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim", ver:"1.2.1-1.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim-dev", ver:"1.2.1-1.4", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
