# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 795-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55234);
 script_bugtraq_id(14381, 14380);
 script_cve_id("CVE-2005-2390");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 795-2 (proftpd)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to proftpd
announced via advisory DSA 795-2.

infamous42md reported that proftpd suffers from two format string
vulnerabilities. In the first, a user with the ability to create a
directory could trigger the format string error if there is a
proftpd shutdown message configured to use the %C, %R, or %U
variables. In the second, the error is triggered if mod_sql is used
to retrieve messages from a database and if format strings have been
inserted into the database by a user with permission to do so.

There was a build error for the sarge i386 proftpd packages released
in DSA 795-1. A new build, 1.2.10-15sarge1.0.1, has been prepared to
correct this error. The packages for other architectures are
unaffected.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20795-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 795-2 (proftpd)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd", ver:"1.2.10-15sarge1.0.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-common", ver:"1.2.10-15sarge1.0.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-ldap", ver:"1.2.10-15sarge1.0.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mysql", ver:"1.2.10-15sarge1.0.1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-pgsql", ver:"1.2.10-15sarge1.0.1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
