# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 895-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55873);
 script_bugtraq_id(15007);
 script_cve_id("CVE-2005-3149");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 895-1 (uim)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to uim
announced via advisory DSA 895-1.

Masanari Yamamoto discovered incorrect use of environment variables in
uim, a flexible input method collection and library, that could lead
to escalated privileges in setuid/setgid applications linked to
libuim.  Affected in Debian is at least mlterm.

The old stable distribution (woody) does not contain uim packags.

For the stable distribution (sarge) this problem has been fixed in
version 0.4.6final1-3sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 0.4.7-2.

We recommend that you upgrade your libuim packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20895-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 895-1 (uim)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"uim-common", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim-dev", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim-nox-dev", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim0", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim0-dbg", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim0-nox", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libuim0-nox-dbg", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-anthy", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-applet-gnome", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-canna", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-fep", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-gtk2.0", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-m17nlib", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-prime", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-skk", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-utils", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"uim-xim", ver:"0.4.6final1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
