# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 988-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56394);
 script_cve_id("CVE-2006-0377", "CVE-2006-0195", "CVE-2006-0188");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 988-1 (squirrelmail)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to squirrelmail
announced via advisory DSA 988-1.

Several vulnerabilities have been discovered in Squirrelmail, a
commonly used webmail system.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2006-0188

Martijn Brinkers and Ben Maurer found a flaw in webmail.php that
allows remote attackers to inject arbitrary web pages into the right
frame via a URL in the right_frame parameter.

CVE-2006-0195

Martijn Brinkers and Scott Hughes discovered an interpretation
conflict in the MagicHTML filter that allows remote attackers to
conduct cross-site scripting (XSS) attacks via style sheet
specifiers with invalid (1) /* and */ comments, or (2) slashes
inside the url keyword, which is processed by some web browsers
including Internet Explorer.

CVE-2006-0377

Vicente Aguilera of Internet Security Auditors, S.L. discovered a
CRLF injection vulnerability, which allows remote attackers to
inject arbitrary IMAP commands via newline characters in the mailbox
parameter of the sqimap_mailbox_select command, aka IMAP
injection. There's no known way to exploit this yet.

For the old stable distribution (woody) these problems have been fixed in
version 1.2.6-5.

For the stable distribution (sarge) these problems have been fixed in
version 2:1.4.4-8.

For the unstable distribution (sid) these problems have been fixed in
version 2:1.4.6-1.

We recommend that you upgrade your squirrelmail package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20988-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 988-1 (squirrelmail)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.2.6-5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squirrelmail", ver:"1.4.4-8", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
