# kst-gpl
#
#       This script was written by Justin Seitz <jms@bughunter.ca>
#	Per Justin : GPLv2
#


desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by a SQL
injection vulnerability. 

Description:

The remote web server is running Etomite CMS, a PHP-based content
management system. 

The version of Etomite CMS installed on the remote host fails to
sanitize input to the 'id' parameter before using it in the
'index.php' script in a database query.  Provided PHP's
'magic_quotes_gpc' setting is disabled, an unauthenticated attacker
can exploit this issue to manipulate SQL queries, possibly leading to
disclosure of sensitive data, attacks against the underlying database,
and the like. 

See also :

http://www.securityfocus.com/archive/1/451838/30/0/threaded

Solution :

No patches or upgrades have been reported by the vendor at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";

if(description)
{
 # set script identifiers

 script_id(80057);;
 script_version("$Revision: 1.9 $");

 script_cve_id("CVE-2006-6048");
 script_bugtraq_id(21135);
 script_xref(name:"OSVDB", value:"30442");

 name["english"] = "Etomite CMS id Paramater SQL Injection";
 summary["english"] = "Tries to generate a SQL error with Etomite CMS";
 family["english"] = "CGI abuses";

 script_name(english:name["english"]);
 script_description(english:desc["english"]);
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2006 Justin Seitz");

 script_family(english:family["english"]);

 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");
port = get_http_port(default:80);

#
# verify we can talk to the web server, if not exit
#

if(!get_port_state(port)) exit(0);
if(!can_host_php(port:port)) exit(0);

#
# create list of directories to scan
#


# Loop through directories.

if (thorough_tests) dirs = make_list("/etomite","/cms", cgi_dirs());
else dirs = make_list(cgi_dirs());

#
# Iterate through the list
#

injectstring = rand_str(charset:"abcdefghijklmnopqrstuvwxyz0123456789_", length:10);

foreach dir (dirs) {

	#
	#
	#       Attack: Attempt to inject our random string.
	#
	#
	
	attackreq = http_get(item:string(dir, "/index.php?id=", injectstring, "'"),port:port);
	attackres = http_keepalive_send_recv(port:port, data:attackreq, bodyonly:TRUE);
	if (attackres == NULL) exit(0);
	
	sqlstring = "";
	if(string("etomite_site_content.id = '", injectstring) >< attackres) {
            if (report_verbosity > 1) {
			sqlstring = attackres;
			if("<span id='sqlHolder'>" >< sqlstring) sqlstring = strstr(sqlstring,"SELECT");
			
			if("</span></b>" >< sqlstring) sqlstring = sqlstring - strstr(sqlstring, "</span></b>");			


			info = string("The version of Etomite CMS installed in directory '", dir, "'\n",
	        	"is vulnerable to this issue. Here is the resulting SQL string\n",
			"from the remote host when using a test string of '",injectstring,"'  :\n\n", sqlstring);
		     	report = string(desc["english"],"\n\nPlugin output\n\n",info);
            }
            else report = desc["english"];

            security_warning(data:report, port:port);
	    set_kb_item(name: 'www/'+port+'/SQLInjection', value: TRUE);
            exit(0);
	}
}
