# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1147 (glpi)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63293);
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-1147 (glpi)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to glpi
announced via advisory FEDORA-2009-1147.

Update Information:

Upstream Changelog :
Version 0.71.5  - Regression on list order
Version 0.71.4  - [SECURITY] SQL injection problem
                - Manage UTF8 filename
                - Search Engine fails for Computer / Peripheral
                - Error in VNC display on report infocom
                - RDV are note display in the planning

ChangeLog:

* Mon Jan 26 2009 Remi Collet  - 0.71.5-1
- update to 0.71.5 (Fix regression in 0.71.4)
* Mon Jan 26 2009 Remi Collet  - 0.71.4-1
- update to 0.71.4 (Security Release)

References:

[ 1 ] Bug #481558 - glpi: multiple SQL injection flaws
https://bugzilla.redhat.com/show_bug.cgi?id=481558

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update glpi' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1147

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-1147 (glpi)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"glpi", rpm:"glpi~0.71.5~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
