# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3011 (argyllcms)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63671);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3011 (argyllcms)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to argyllcms
announced via advisory FEDORA-2009-3011.

Update Information:

Multiple integer overflows were found in the International Color  Consortium
Format Library (icclib). An attacker could use this flaw to  potentially execute
arbitrary code by requesting to translate a specially-  crafted image file
created on one device into another's device native color  space via a device
file.

ChangeLog:

* Mon Mar 23 2009 Jon Ciesla  - 1.0.3-3
- Patch for ICC library CVE-2009-{0583, 0584} by Tim Waugh.
* Mon Feb 23 2009 Fedora Release Engineering  - 1.0.3-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

References:

[ 1 ] Bug #487742 - CVE-2009-0583 ghostscript: Multiple integer overflows in the International Color Consortium Format Library
https://bugzilla.redhat.com/show_bug.cgi?id=487742
[ 2 ] Bug #487744 - CVE-2009-0584 ghostscript: Multiple insufficient upper-bounds checks on certain sizes in the International Color Consortium Format Library
https://bugzilla.redhat.com/show_bug.cgi?id=487744

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update argyllcms' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3011

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3011 (argyllcms)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"argyllcms", rpm:"argyllcms~1.0.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"argyllcms-doc", rpm:"argyllcms-doc~1.0.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"argyllcms-debuginfo", rpm:"argyllcms-debuginfo~1.0.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
