#
#VID 7b81fc47-239f-11d9-814e-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52331);
 script_cve_id("CVE-2004-0748", "CVE-2004-0751");
 script_bugtraq_id(11094,11154);
 script_version ("$");
 name["english"] = "FreeBSD Ports: apache";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: apache

CVE-2004-0748
mod_ssl in Apache 2.0.50 and earlier allows remote attackers to cause
a denial of service (CPU consumption) by aborting an SSL connection in
a way that causes an Apache child process to enter an infinite loop.

CVE-2004-0751
The char_buffer_read function in the mod_ssl module for Apache 2.x,
when using reverse proxying to an SSL server, allows remote attackers
to cause a denial of service (segmentation fault).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://nagoya.apache.org/bugzilla/show_bug.cgi?id=29964
http://nagoya.apache.org/bugzilla/show_bug.cgi?id=30134
http://marc.theaimsgroup.com/?l=apache-httpd-announce&m=109527608022322
http://www.vuxml.org/freebsd/7b81fc47-239f-11d9-814e-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: apache";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"apache");
if(!isnull(bver) && revcomp(a:bver, b:"2.0")>0 && revcomp(a:bver, b:"2.0.51")<0) {
    security_note(0, data:"Package apache version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
