#
#VID 5d433534-f41c-402e-ade5-e0a2259a7cb6
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 5d433534-f41c-402e-ade5-e0a2259a7cb6
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63515);
 script_cve_id("CVE-2009-0037");
 script_version ("$");
 name["english"] = "FreeBSD Ports: curl";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: curl

CVE-2009-0037
The redirect implementation in curl and libcurl 5.11 through 7.19.3,
when CURLOPT_FOLLOWLOCATION is enabled, accepts arbitrary Location
values, which might allow remote HTTP servers to (1) trigger arbitrary
requests to intranet servers, (2) read or overwrite arbitrary files
via a redirect to a file: URL, or (3) execute arbitrary commands via a
redirect to an scp: URL.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/34138/
http://www.vuxml.org/freebsd/5d433534-f41c-402e-ade5-e0a2259a7cb6.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: curl";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"curl");
if(!isnull(bver) && revcomp(a:bver, b:"5.11")>=0 && revcomp(a:bver, b:"7.19.4")<0) {
    security_note(0, data:"Package curl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
