#
#VID ca9ce879-5ebb-11d9-a01c-0050569f0001
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52252);
 script_cve_id("CVE-2005-0021", "CVE-2005-0022");
 script_bugtraq_id(12185,12188,12268);
 script_version ("$");
 name["english"] = "exim -- two buffer overflow vulnerabilities";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   exim
   exim-ldap
   exim-ldap2
   exim-mysql
   exim-postgresql
   exim-sa-exim

CVE-2005-0021
Multiple buffer overflows in Exim before 4.43 may allow attackers to
execute arbitrary code via (1) an IPv6 address with more than 8
components, as demonstrated using the -be command line option, which
triggers an overflow in the host_aton function, or (2) the -bh command
line option or dnsdb PTR lookup, which triggers an overflow in the
dns_build_reverse function.

CVE-2005-0022
Buffer overflow in the spa_base64_to_bits function in Exim before
4.43, as originally obtained from Samba code, and as called by the
auth_spa_client function, may allow attackers to execute arbitrary
code during SPA authentication.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.exim.org/mail-archives/exim-announce/2005/msg00000.html
http://marc.theaimsgroup.com/?l=bugtraq&m=110573573800377
http://www.vuxml.org/freebsd/ca9ce879-5ebb-11d9-a01c-0050569f0001.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "exim -- two buffer overflow vulnerabilities";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"exim");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"exim-ldap");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim-ldap version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"exim-ldap2");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim-ldap2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"exim-mysql");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim-mysql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"exim-postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"exim-sa-exim");
if(!isnull(bver) && revcomp(a:bver, b:"4.43+28_1")<0) {
    security_note(0, data:"Package exim-sa-exim version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
