#
#VID 27a70a01-5f6c-11da-8d54-000cf18bbe54
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55907);
 script_cve_id("CVE-2004-0967");
 script_bugtraq_id(11285);
 script_version ("$");
 name["english"] = "FreeBSD Ports: ghostscript-gnu, ghostscript-gnu-nox11";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ghostscript-gnu
   ghostscript-gnu-nox11
   ghostscript-afpl
   ghostscript-afpl-nox11

CVE-2004-0967
The (1) pj-gs.sh, (2) ps2epsi , (3) pv.sh, and (4) sysvlp.sh scripts
in the ESP Ghostscript (espgs) package in Trustix Secure Linux 1.5
through 2.1, and other operating systems, allow local users to
overwrite files via a symlink attack on temporary files.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: ghostscript-gnu, ghostscript-gnu-nox11";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ghostscript-gnu");
if(!isnull(bver) && revcomp(a:bver, b:"7.07_14")<0) {
    security_note(0, data:"Package ghostscript-gnu version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ghostscript-gnu-nox11");
if(!isnull(bver) && revcomp(a:bver, b:"7.07_14")<0) {
    security_note(0, data:"Package ghostscript-gnu-nox11 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ghostscript-afpl");
if(!isnull(bver) && revcomp(a:bver, b:"8.53_1")<0) {
    security_note(0, data:"Package ghostscript-afpl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ghostscript-afpl-nox11");
if(!isnull(bver) && revcomp(a:bver, b:"8.53_1")<0) {
    security_note(0, data:"Package ghostscript-afpl-nox11 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
