#
#VID 7a9d5dfe-c507-11d8-8898-000d6111a684
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52427);
 script_bugtraq_id(10590);
 script_cve_id("CVE-2004-0460");
 script_version ("$");
 name["english"] = "FreeBSD Ports: isc-dhcp3-relay, isc-dhcp3-server";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   isc-dhcp3-relay
   isc-dhcp3-server

CVE-2004-0460
Buffer overflow in the logging capability for the DHCP daemon (DHCPD)
for ISC DHCP 3.0.1rc12 and 3.0.1rc13 allows remote attackers to cause
a denial of service (server crash) and possibly execute arbitrary code
via multiple hostname options in (1) DISCOVER, (2) OFFER, (3) REQUEST,
(4) ACK, or (5) NAK messages, which can generate a long string when
writing to a log file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.osvdb.org/7237
http://www.securityfocus.com/archive/1/366801
http://www.securityfocus.com/archive/1/367286
http://www.vuxml.org/freebsd/7a9d5dfe-c507-11d8-8898-000d6111a684.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: isc-dhcp3-relay, isc-dhcp3-server";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"isc-dhcp3-relay");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1.r12")>=0 && revcomp(a:bver, b:"3.0.1.r14")<0) {
    security_note(0, data:"Package isc-dhcp3-relay version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"isc-dhcp3-server");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.1.r12")>=0 && revcomp(a:bver, b:"3.0.1.r14")<0) {
    security_note(0, data:"Package isc-dhcp3-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
