#
#VID 432bf98d-9e25-11da-b410-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56270);
 script_cve_id("CVE-2006-0301");
 script_version ("$");
 name["english"] = "FreeBSD Ports: kdegraphics";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: kdegraphics

CVE-2006-0301
Heap-based buffer overflow in Splash.cc in xpdf, as used in other
products such as (1) poppler, (2) kdegraphics, (3) gpdf, (4)
pdfkit.framework, and others, allows attackers to cause a denial of
service and possibly execute arbitrary code via crafted splash images
that produce certain values that exceed the width or height of the
associated bitmap.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.kde.org/info/security/advisory-20060202-1.txt
http://www.vuxml.org/freebsd/432bf98d-9e25-11da-b410-000e0c2e438a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: kdegraphics";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"kdegraphics");
if(!isnull(bver) && revcomp(a:bver, b:"3.5.1_1")<0) {
    security_note(0, data:"Package kdegraphics version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
