#
#VID 2b2b333b-6bd3-11d9-95f8-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52214);
 script_cve_id("CVE-2004-1004", "CVE-2004-1005", "CVE-2004-1009", "CVE-2004-1090", "CVE-2004-1091", "CVE-2004-1092", "CVE-2004-1093");
 script_version ("$");
 name["english"] = "FreeBSD Ports: mc";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mc

CVE-2004-1004
Multiple format string vulnerabilities in Midnight Commander (mc)
4.5.55 and earlier allow remote attackers to have an unknown impact.

CVE-2004-1005
Multiple buffer overflows in Midnight Commander (mc) 4.5.55 and
earlier allow remote attackers to have an unknown impact.

CVE-2004-1009
Midnight commander (mc) 4.5.55 and earlier allows remote attackers to
cause a denial of service (infinite loop) via unknown attack vectors.

CVE-2004-1090
Midnight commander (mc) 4.5.55 and earlier allows remote attackers to
cause a denial of service via 'a corrupt section header.'

CVE-2004-1091
Midnight commander (mc) 4.5.55 and earlier allows remote attackers to
cause a denial of service by triggering a null dereference.

CVE-2004-1092
Midnight commander (mc) 4.5.55 and earlier allows remote attackers to
cause a denial of service by causing mc to free unallocated memory.

CVE-2004-1093
Midnight commander (mc) 4.5.55 and earlier allows remote attackers to
cause a denial of service via 'use of already freed memory.'

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mc";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mc");
if(!isnull(bver) && revcomp(a:bver, b:"4.6.0")<0) {
    security_note(0, data:"Package mc version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
