#
#VID 4913886c-e875-11da-b9f4-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56850);
 script_cve_id("CVE-2006-1516", "CVE-2006-1517", "CVE-2006-1518");
 script_version ("$");
 name["english"] = "FreeBSD Ports: mysql-server";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-server

CVE-2006-1516
The check_connection function in sql_parse.cc in MySQL 4.0.x up to
4.0.26, 4.1.x up to 4.1.18, and 5.0.x up to 5.0.20 allows remote
attackers to read portions of memory via a username without a trailing
null byte, which causes a buffer over-read.

CVE-2006-1517
sql_parse.cc in MySQL 4.0.x up to 4.0.26, 4.1.x up to 4.1.18, and
5.0.x up to 5.0.20 allows remote attackers to obtain sensitive
information via a COM_TABLE_DUMP request with an incorrect packet
length, which includes portions of memory in an error message.

CVE-2006-1518
Buffer overflow in the open_table function in sql_base.cc in MySQL
5.0.x up to 5.0.20 might allow remote attackers to execute arbitrary
code via crafted COM_TABLE_DUMP packets with invalid length values.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.wisec.it/vulns.php?page=7
http://www.wisec.it/vulns.php?page=8
http://dev.mysql.com/doc/refman/4.1/en/news-4-0-27.html
http://dev.mysql.com/doc/refman/4.1/en/news-4-1-19.html
http://dev.mysql.com/doc/refman/5.1/en/news-5-1-10.html
http://secunia.com/advisories/19929/
http://www.vuxml.org/freebsd/a8d8713e-dc83-11da-a22b-000c6ec775d9.html
http://www.vuxml.org/freebsd/4913886c-e875-11da-b9f4-00123ffe8333.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: mysql-server";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-server");
if(!isnull(bver) && revcomp(a:bver, b:"4.0")>0 && revcomp(a:bver, b:"4.0.27")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"4.1")>0 && revcomp(a:bver, b:"4.1.19")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"5.1")>0 && revcomp(a:bver, b:"5.1.9")<=0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
