#
#ADV FreeBSD-SA-06:23.openssl.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(57475);
 script_cve_id("CVE-2006-2937");
 script_version ("$");
 name["english"] = "FreeBSD Security Advisory (FreeBSD-SA-06:23.openssl.asc)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-06:23.openssl.asc

FreeBSD includes software from the OpenSSL Project.  The OpenSSL Project is
a collaborative effort to develop a robust, commercial-grade, full-featured,
and Open Source toolkit implementing the Secure Sockets Layer (SSL v2/v3)
and Transport Layer Security (TLS v1) protocols as well as a full-strength
general purpose cryptography library.

Several problems have been found in OpenSSL:

1. During the parsing of certain invalid ASN1 structures an error condition
is mishandled, possibly resulting in an infinite loop.  [CVE-2006-2937]

2. A buffer overflow exists in the SSL_get_shared_ciphers function.
[CVE-2006-3738]

3. A NULL pointer may be dereferenced in the SSL version 2 client code.
[CVE-2006-4343]

In addition, many applications using OpenSSL do not perform any validation
of the lengths of public keys being used. [CVE-2006-2940]

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-06:23.openssl.asc
Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Security Advisory (FreeBSD-SA-06:23.openssl.asc)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.1", patchlevel:"8")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.0", patchlevel:"13")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"6")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.4", patchlevel:"20")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.3", patchlevel:"35")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"4.11", patchlevel:"23")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
