###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for cups CESA-2008:0157 centos5 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880262);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0157");
  script_cve_id("CVE-2008-0882");
  script_name(english: "CentOS Update for cups CESA-2008:0157 centos5 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  The Common UNIX Printing System (CUPS) provides a portable printing layer
  for UNIX(R) operating systems. The Internet Printing Protocol (IPP) is a
  standard network protocol for remote printing, as well as managing print
  jobs.
  
  A flaw was found in the way CUPS handles the addition and removal of remote
  shared printers via IPP. A remote attacker could send malicious UDP IPP
  packets causing the CUPS daemon to crash. (CVE-2008-0882)
  
  Note: the default configuration of CUPS on Red Hat Enterprise Linux 5 will
  only accept requests of this type from the local subnet. This issue did not
  affect the versions of CUPS as shipped with Red Hat Enterprise Linux 3 or
  4.
  
  All cups users are advised to upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  cups on CentOS 5

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-February/014705.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS5")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.2.4~11.14.el5_1.4", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.2.4~11.14.el5_1.4", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.2.4~11.14.el5_1.4", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-lpd", rpm:"cups-lpd~1.2.4~11.14.el5_1.4", rls:"CENTOS5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}