###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for openoffice.org CESA-2008:0176 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880020);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0176");
  script_cve_id("CVE-2007-5746", "CVE-2008-0320");
  script_name(english: "CentOS Update for openoffice.org CESA-2008:0176 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  OpenOffice.org is an office productivity suite that includes desktop
  applications such as a word processor, spreadsheet, presentation manager,
  formula editor, and drawing program.
  
  A heap overflow flaw was found in the EMF parser. An attacker could create
  a carefully crafted EMF file that could cause OpenOffice.org to crash or
  possibly execute arbitrary code if the malicious EMF image was added to a
  document or if a document containing the malicious EMF file was opened by a
  victim. (CVE-2007-5746)
  
  A heap overflow flaw was found in the OLE Structured Storage file parser.
  (OLE Structured Storage is a format used by Microsoft Office documents.) An
  attacker could create a carefully crafted OLE file that could cause
  OpenOffice.org to crash or possibly execute arbitrary code if the file was
  opened by a victim. (CVE-2008-0320)
  
  All users of OpenOffice.org are advised to upgrade to these updated
  packages, which contain backported fixes to correct these issues.


  Affected Software/OS:
  openoffice.org on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-April/014825.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openoffice.org");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"openoffice.org", rpm:"openoffice.org~1.1.2~41.2.0.EL3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openoffice.org-i18n", rpm:"openoffice.org-i18n~1.1.2~41.2.0.EL3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openoffice.org-libs", rpm:"openoffice.org-libs~1.1.2~41.2.0.EL3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}