###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for firefox CESA-2008:0598 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880283);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0598");
  script_cve_id("CVE-2008-2785", "CVE-2008-2933");
  script_name(english: "CentOS Update for firefox CESA-2008:0598 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Firefox is an open source Web browser.
  
  An integer overflow flaw was found in the way Firefox displayed certain web
  content. A malicious web site could cause Firefox to crash, or execute
  arbitrary code with the permissions of the user running Firefox.
  (CVE-2008-2785)
  
  A flaw was found in the way Firefox handled certain command line URLs. If
  another application passed Firefox a malformed URL, it could result in
  Firefox executing local malicious content with chrome privileges.
  (CVE-2008-2933)
  
  All firefox users should upgrade to this updated package, which contains
  backported patches that correct these issues.


  Affected Software/OS:
  firefox on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-July/015145.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"firefox", rpm:"firefox~1.5.0.12~0.21.el4.centos3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}