###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for vim CESA-2008:0618-01 centos2 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880301);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0618-01");
  script_cve_id("CVE-2008-2712", "CVE-2008-4101");
  script_name(english: "CentOS Update for vim CESA-2008:0618-01 centos2 i386");
  desc["english"] = "

  Vulnerability Insight:
  Vim (Visual editor IMproved) is an updated and improved version of the vi
  editor.
  
  Several input sanitization flaws were found in Vim's keyword and tag
  handling. If Vim looked up a document's maliciously crafted tag or keyword,
  it was possible to execute arbitrary code as the user running Vim.
  (CVE-2008-4101)
  
  Several input sanitization flaws were found in various Vim system
  functions. If a user opened a specially crafted file, it was possible to
  execute arbitrary code as the user running Vim. (CVE-2008-2712)
  
  All Vim users are advised to upgrade to these updated packages, which
  contain backported patches to correct these issues.


  Affected Software/OS:
  vim on CentOS 2

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-November/015444.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of vim");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS2")
{

  if(isrpmvuln(pkg:"vim-common", rpm:"vim-common~6.0~7.25", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-enhanced", rpm:"vim-enhanced~6.0~7.25", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-minimal", rpm:"vim-minimal~6.0~7.25", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"vim-X11", rpm:"vim-X11~6.0~7.25", rls:"CENTOS2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}