###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for wireshark CESA-2008:0890 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880181);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0890");
  script_cve_id("CVE-2008-1070", "CVE-2008-1071", "CVE-2008-1072", "CVE-2008-1561", "CVE-2008-1562", "CVE-2008-1563", "CVE-2008-3137", "CVE-2008-3138", "CVE-2008-3141", "CVE-2008-3145", "CVE-2008-3146", "CVE-2008-3932", "CVE-2008-3933", "CVE-2008-3934");
  script_name(english: "CentOS Update for wireshark CESA-2008:0890 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  Wireshark is a program for monitoring network traffic. Wireshark was
  previously known as Ethereal.
  
  Multiple buffer overflow flaws were found in Wireshark. If Wireshark read
  a malformed packet off a network, it could crash or, possibly, execute
  arbitrary code as the user running Wireshark. (CVE-2008-3146)
  
  Several denial of service flaws were found in Wireshark. Wireshark could
  crash or stop responding if it read a malformed packet off a network, or
  opened a malformed dump file. (CVE-2008-1070, CVE-2008-1071, CVE-2008-1072,
  CVE-2008-1561, CVE-2008-1562, CVE-2008-1563, CVE-2008-3137, CVE-2008-3138,
  CVE-2008-3141, CVE-2008-3145, CVE-2008-3932, CVE-2008-3933, CVE-2008-3934)
  
  Additionally, this update changes the default Pluggable Authentication
  Modules (PAM) configuration to always prompt for the root password before
  each start of Wireshark. This avoids unintentionally running Wireshark with
  root privileges.
  
  Users of wireshark should upgrade to these updated packages, which contain
  Wireshark version 1.0.3, and resolve these issues.


  Affected Software/OS:
  wireshark on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-October/015282.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.3~EL3.3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.3~EL3.3", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}