###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for libxml2 CESA-2008:0988 centos3 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880309);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0988");
  script_cve_id("CVE-2008-4225", "CVE-2008-4226");
  script_name(english: "CentOS Update for libxml2 CESA-2008:0988 centos3 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  libxml2 is a library for parsing and manipulating XML files. It includes
  support for reading, modifying, and writing XML and HTML files.
  
  An integer overflow flaw causing a heap-based buffer overflow was found in
  the libxml2 XML parser. If an application linked against libxml2 processed
  untrusted, malformed XML content, it could cause the application to crash
  or, possibly, execute arbitrary code. (CVE-2008-4226)
  
  A denial of service flaw was discovered in the libxml2 XML parser. If an
  application linked against libxml2 processed untrusted, malformed XML
  content, it could cause the application to enter an infinite loop.
  (CVE-2008-4225)
  
  Red Hat would like to thank Drew Yao of the Apple Product Security team for
  reporting these issues.
  
  Users of libxml2 are advised to upgrade to these updated packages, which
  contain backported patches to correct these issues.


  Affected Software/OS:
  libxml2 on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-November/015415.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libxml2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.5.10~14", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.5.10~14", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.5.10~14", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}