###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for bind RHSA-2008:0300-02
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870118);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0300-02");
  script_cve_id("CVE-2007-6283", "CVE-2008-0122");
  script_name(english: "RedHat Update for bind RHSA-2008:0300-02");
  desc["english"] = "

  Vulnerability Insight:
  The Berkeley Internet Name Domain (BIND) is an implementation of the Domain
  Name System (DNS) protocols. BIND includes a DNS server (named); a resolver
  library (routines for applications to use when interfacing with DNS); and
  tools for verifying that the DNS server is operating correctly.
  
  It was discovered that the bind packages created the &quot;rndc.key&quot; file with
  insecure file permissions. This allowed any local user to read the content
  of this file. A local user could use this flaw to control some aspects of
  the named daemon by using the rndc utility, for example, stopping the named
  daemon. This problem did not affect systems with the bind-chroot package
  installed. (CVE-2007-6283)
  
  A buffer overflow flaw was discovered in the &quot;inet_network()&quot; function, as
  implemented by libbind. An attacker could use this flaw to crash an
  application calling this function, with an argument provided from an
  untrusted source. (CVE-2008-0122)
  
  As well, these updated packages fix the following bugs:
  
  * when using an LDAP backend, missing function declarations caused
  segmentation faults, due to stripped pointers on machines where pointers
  are longer than integers.
  
  * starting named may have resulted in named crashing, due to a race
  condition during D-BUS connection initialization. This has been resolved in
  these updated packages.
  
  * the named init script returned incorrect error codes, causing the
  &quot;status&quot; command to return an incorrect status. In these updated packages,
  the named init script is Linux Standard Base (LSB) compliant.
  
  * in these updated packages, the &quot;rndc [command] [zone]&quot; command, where
  [command] is an rndc command, and [zone] is the specified zone, will find
  the [zone] if the zone is unique to all views.
  
  * the default named log rotation script did not work correctly when using
  the bind-chroot package. In these updated packages, installing
  bind-chroot creates the symbolic link &quot;/var/log/named.log&quot;, which points
  to &quot;/var/named/chroot/var/log/named.log&quot;, which resolves this issue.
  
  * a previous bind update incorrectly changed the permissions on the
  &quot;/etc/openldap/schema/dnszone.schema&quot; file to mode 640, instead of mode
  644, which resulted in OpenLDAP not being able to start. In these updated
  packages, the permissions are correctly set to mode 644.
  
  * the &quot;checkconfig&quot; parameter was missing in the named usage report. For
  example, running the &quot;service named&quot; command did not return &quot;checkconfi ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  bind on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00020.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libbind-devel", rpm:"bind-libbind-devel~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-sdb", rpm:"bind-sdb~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"caching-nameserver", rpm:"caching-nameserver~9.3.4~6.P1.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}