###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for pidgin RHSA-2008:0584-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870107);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0584-01");
  script_cve_id("CVE-2008-2927");
  script_name(english: "RedHat Update for pidgin RHSA-2008:0584-01");
  desc["english"] = "

  Vulnerability Insight:
  Pidgin is a multi-protocol Internet Messaging client.
  
  An integer overflow flaw was found in Pidgin's MSN protocol handler. If a
  user received a malicious MSN message, it was possible to execute arbitrary
  code with the permissions of the user running Pidgin. (CVE-2008-2927)
  
  Note: the default Pidgin privacy setting only allows messages from users in
  the buddy list. This prevents arbitrary MSN users from exploiting this
  flaw.
  
  This update also addresses the following bug:
  
  * when attempting to connect to the ICQ network, Pidgin would fail to
  connect, present an alert saying the &quot;The client version you are using is
  too old&quot;, and de-activate the ICQ account. This update restores Pidgin's
  ability to connect to the ICQ network.
  
  All Pidgin users should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  pidgin on Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-July/msg00008.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~1.5.1~2.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~1.5.1~2.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~1.5.1~2.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~1.5.1~2.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}