###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for hplip RHSA-2008:0818-02
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870097);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0818-02");
  script_cve_id("CVE-2008-2940", "CVE-2008-2941");
  script_name(english: "RedHat Update for hplip RHSA-2008:0818-02");
  desc["english"] = "

  Vulnerability Insight:
  The hplip (Hewlett-Packard Linux Imaging and Printing) packages provide
  drivers for Hewlett-Packard printers and multifunction peripherals.
  
  A flaw was discovered in the hplip alert-mailing functionality. A local
  attacker could elevate their privileges by using specially-crafted packets
  to trigger alert mails, which are sent by the root account. (CVE-2008-2940)
  
  A flaw was discovered in the hpssd message parser. By sending
  specially-crafted packets, a local attacker could cause a denial of
  service, stopping the hpssd process. (CVE-2008-2941)
  
  Users of hplip should upgrade to these updated packages, which contain
  backported patches to correct these issues.


  Affected Software/OS:
  hplip on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00008.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of hplip");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.6.7~4.1.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.6.7~4.1.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-debuginfo", rpm:"hplip-debuginfo~1.6.7~4.1.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio", rpm:"libsane-hpaio~1.6.7~4.1.el5_2.4", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}