###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libtiff RHSA-2008:0847-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870026);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0847-01");
  script_cve_id("CVE-2008-2327");
  script_name(english: "RedHat Update for libtiff RHSA-2008:0847-01");
  desc["english"] = "

  Vulnerability Insight:
  The libtiff packages contain a library of functions for manipulating Tagged
  Image File Format (TIFF) files.
  
  Multiple uses of uninitialized values were discovered in libtiff's
  Lempel-Ziv-Welch (LZW) compression algorithm decoder. An attacker could
  create a carefully crafted LZW-encoded TIFF file that would cause an
  application linked with libtiff to crash or, possibly, execute arbitrary
  code. (CVE-2008-2327)
  
  Red Hat would like to thank Drew Yao of the Apple Product Security team for
  reporting this issue.
  
  Additionally, these updated packages fix the following bug:
  
  * the libtiff packages included manual pages for the sgi2tiff and tiffsv
  commands, which are not included in these packages. These extraneous manual
  pages were removed.
  
  All libtiff users are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  libtiff on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00025.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libtiff");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"libtiff", rpm:"libtiff~3.8.2~7.el5_2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtiff-debuginfo", rpm:"libtiff-debuginfo~3.8.2~7.el5_2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~7.el5_2.2", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}