###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for openssh RHSA-2008:0855-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870129);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0855-01");
  script_cve_id("CVE-2007-4752");
  script_name(english: "RedHat Update for openssh RHSA-2008:0855-01");
  desc["english"] = "

  Vulnerability Insight:
  OpenSSH is OpenBSD's SSH (Secure SHell) protocol implementation. 
  
  Last week Red Hat detected an intrusion on certain of its computer systems
  and took immediate action. While the investigation into the intrusion is
  on-going, our initial focus  was to review and test the distribution
  channel we use with our customers, Red Hat Network (RHN) and its associated
  security measures. Based on these efforts, we remain highly confident that
  our systems and processes prevented the intrusion from compromising RHN or
  the content distributed via RHN and accordingly believe that customers who
  keep their systems updated using Red Hat Network are not at risk.  We are
  issuing this alert primarily for those who may obtain Red Hat binary
  packages via channels other than those of official Red Hat subscribers.
  
  In connection with the incident, the intruder was able to sign a small
  number of OpenSSH packages relating only to Red Hat Enterprise Linux 4
  (i386 and x86_64 architectures only) and Red Hat Enterprise Linux 5 (x86_64
  architecture only).  As a precautionary measure, we are releasing an
  updated version of these packages, and have published a list of the
  tampered packages and how to detect them at
  <a  rel= &qt nofollow &qt  href= &qt http://www.redhat.com/security/data/openssh-blacklist.html &qt >http://www.redhat.com/security/data/openssh-blacklist.html</a>
  
  To reiterate, our processes and efforts to date indicate that packages
  obtained by Red Hat Enterprise Linux subscribers via Red Hat Network are
  not at risk.
  
  These packages also fix a low severity flaw in the way ssh handles X11
  cookies when creating X11 forwarding connections.  When ssh was unable to
  create untrusted cookie, ssh used a trusted cookie instead, possibly
  allowing the administrative user of a untrusted remote server, or untrusted
  application run on the remote server, to gain unintended access to a users
  local X server. (CVE-2007-4752)


  Affected Software/OS:
  openssh on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4,
  Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-August/msg00017.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openssh");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"openssh", rpm:"openssh~4.3p2~26.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-askpass", rpm:"openssh-askpass~4.3p2~26.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-clients", rpm:"openssh-clients~4.3p2~26.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-debuginfo", rpm:"openssh-debuginfo~4.3p2~26.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-server", rpm:"openssh-server~4.3p2~26.el5_2.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"openssh", rpm:"openssh~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-askpass", rpm:"openssh-askpass~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-askpass-gnome", rpm:"openssh-askpass-gnome~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-clients", rpm:"openssh-clients~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-debuginfo", rpm:"openssh-debuginfo~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openssh-server", rpm:"openssh-server~3.9p1~11.el4_7", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}