###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for thunderbird RHSA-2008:0908-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870158);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0908-01");
  script_cve_id("CVE-2008-0016", "CVE-2008-3835", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4065", "CVE-2008-4066", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4070");
  script_name(english: "RedHat Update for thunderbird RHSA-2008:0908-01");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Thunderbird is a standalone mail and newsgroup client.
  
  Several flaws were found in the processing of malformed HTML mail content.
  An HTML mail message containing malicious content could cause Thunderbird
  to crash or, potentially, execute arbitrary code as the user running
  Thunderbird. (CVE-2008-0016, CVE-2008-4058, CVE-2008-4059, CVE-2008-4060,
  CVE-2008-4061, CVE-2008-4062)
  
  Several flaws were found in the way malformed HTML mail content was
  displayed. An HTML mail message containing specially crafted content could
  potentially trick a Thunderbird user into surrendering sensitive
  information. (CVE-2008-3835, CVE-2008-4067, CVE-2008-4068)
  
  A flaw was found in Thunderbird that caused certain characters to be
  stripped from JavaScript code. This flaw could allow malicious JavaScript
  to bypass or evade script filters. (CVE-2008-4065, CVE-2008-4066)
  
  Note: JavaScript support is disabled by default in Thunderbird; the above
  issue is not exploitable unless JavaScript is enabled.
  
  A heap based buffer overflow flaw was found in the handling of cancelled
  newsgroup messages. If the user cancels a specially crafted newsgroup
  message it could cause Thunderbird to crash or, potentially, execute
  arbitrary code as the user running Thunderbird. (CVE-2008-4070)
  
  All Thunderbird users should upgrade to these updated packages, which
  resolve these issues.


  Affected Software/OS:
  thunderbird on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-October/msg00002.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"thunderbird", rpm:"thunderbird~1.5.0.12~16.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"thunderbird-debuginfo", rpm:"thunderbird-debuginfo~1.5.0.12~16.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}