###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_evolution_data_server_detect.nasl 958 2009-03-16 18:40:29Z mar $
#
# Evolution Data Server Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800253);
  script_version("$Revision: 1.0 $");
  script_name(english:"Evolution Data Server Version Detection (Linux)");
  desc["english"] = "

  Overview: The script detects the version of Evolution and sets the result
  in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for Evolution version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

evolution = find_file(file_name:"evolution", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:sock);

foreach binaryName (evolution)
{
  binaryName = chomp(binaryName);
  evolutionVer = get_bin_version(full_prog_name:binaryName, version_argv:"--version",
                              ver_pattern:"evolution ([0-9.]+)", sock:sock);
  if(evolutionVer[1] != NULL)
  {
    set_kb_item(name:"Evolution/Ver", value:evolutionVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
