###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for NetworkManager FEDORA-2007-0186
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861316);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-0186");
  script_cve_id("");
  script_name(english: "Fedora Update for NetworkManager FEDORA-2007-0186");
  desc["english"] = "

  Vulnerability Insight:
  NetworkManager attempts to keep an active network connection available at all
  times.  It is intended only for the desktop use-case, and is not intended for
  usage on servers.   The point of NetworkManager is to make networking
  configuration and setup as painless and automatic as possible.  If using DHCP,
  NetworkManager is _intended_ to replace default routes, obtain IP addresses
  from a DHCP server, and change nameservers whenever it sees fit.


  Affected Software/OS:
  NetworkManager on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-June/msg00032.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of NetworkManager");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-debuginfo", rpm:"NetworkManager-debuginfo~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-glib-devel", rpm:"NetworkManager-glib-devel~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-glib-devel", rpm:"NetworkManager-glib-devel~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-debuginfo", rpm:"NetworkManager-debuginfo~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.6.5~3.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}