###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for krb5 FEDORA-2007-033
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861084);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-033");
  script_cve_id("CVE-2006-6143", "CVE-2006-6144");
  script_name(english: "Fedora Update for krb5 FEDORA-2007-033");
  desc["english"] = "

  Vulnerability Insight:
  Kerberos V5 is a trusted-third-party network authentication system,
  which can improve your network's security by eliminating the insecure
  practice of cleartext passwords.


  Affected Software/OS:
  krb5 on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00046.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of krb5");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"krb5", rpm:"krb5~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/krb5-workstation", rpm:"x86_64/krb5-workstation~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/krb5-debuginfo", rpm:"x86_64/debug/krb5-debuginfo~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/krb5-devel", rpm:"x86_64/krb5-devel~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/krb5-libs", rpm:"x86_64/krb5-libs~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/krb5-server", rpm:"x86_64/krb5-server~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/krb5-debuginfo", rpm:"i386/debug/krb5-debuginfo~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/krb5-libs", rpm:"i386/krb5-libs~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/krb5-workstation", rpm:"i386/krb5-workstation~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/krb5-server", rpm:"i386/krb5-server~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/krb5-devel", rpm:"i386/krb5-devel~1.5~13", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}