###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for claws-mail FEDORA-2007-2009
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861572);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2009");
  script_cve_id("CVE-2007-2958");
  script_name(english: "Fedora Update for claws-mail FEDORA-2007-2009");
  desc["english"] = "

  Vulnerability Insight:
  Claws Mail is an email client (and news reader), based on GTK+, featuring
  quick response, graceful and sophisticated interface, easy configuration,
  intuitive operation, abundant features, extensibility


  Affected Software/OS:
  claws-mail on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-September/msg00077.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of claws-mail");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"claws-mail", rpm:"claws-mail~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-debuginfo", rpm:"claws-mail-debuginfo~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-pgp", rpm:"claws-mail-plugins-pgp~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-devel", rpm:"claws-mail-devel~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-bogofilter", rpm:"claws-mail-plugins-bogofilter~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-clamav", rpm:"claws-mail-plugins-clamav~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-dillo", rpm:"claws-mail-plugins-dillo~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail", rpm:"claws-mail~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-spamassassin", rpm:"claws-mail-plugins-spamassassin~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-clamav", rpm:"claws-mail-plugins-clamav~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-pgp", rpm:"claws-mail-plugins-pgp~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-spamassassin", rpm:"claws-mail-plugins-spamassassin~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-dillo", rpm:"claws-mail-plugins-dillo~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-debuginfo", rpm:"claws-mail-debuginfo~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail", rpm:"claws-mail~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-plugins-bogofilter", rpm:"claws-mail-plugins-bogofilter~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"claws-mail-devel", rpm:"claws-mail-devel~3.0.0~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}