###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gnome-python2-extras FEDORA-2007-293
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861135);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-293");
  script_cve_id("");
  script_name(english: "Fedora Update for gnome-python2-extras FEDORA-2007-293");
  desc["english"] = "

  Vulnerability Insight:
  The gnome-python-extra package contains the source packages for additional
  Python bindings for GNOME. It should be used together with gnome-python.
  
  ---------------------------------------------------------------------
  
  * Mon Feb 26 2007 Matthew Barnes &lt;mbarnes redhat com&gt; - 2.14.2-9.fc6
  - Rebuild against firefox-1.5.0.10


  Affected Software/OS:
  gnome-python2-extras on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-February/msg00164.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of gnome-python2-extras");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"gnome-python2-extras", rpm:"gnome-python2-extras~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gnome-python2-libegg", rpm:"x86_64/gnome-python2-libegg~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gnome-python2-gtkspell", rpm:"x86_64/gnome-python2-gtkspell~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gnome-python2-gtkmozembed", rpm:"x86_64/gnome-python2-gtkmozembed~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/gnome-python2-extras-debuginfo", rpm:"x86_64/debug/gnome-python2-extras-debuginfo~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gnome-python2-extras", rpm:"x86_64/gnome-python2-extras~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/gnome-python2-gtkhtml2", rpm:"x86_64/gnome-python2-gtkhtml2~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/gnome-python2-extras-debuginfo", rpm:"i386/debug/gnome-python2-extras-debuginfo~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gnome-python2-gtkspell", rpm:"i386/gnome-python2-gtkspell~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gnome-python2-libegg", rpm:"i386/gnome-python2-libegg~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gnome-python2-extras", rpm:"i386/gnome-python2-extras~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gnome-python2-gtkmozembed", rpm:"i386/gnome-python2-gtkmozembed~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/gnome-python2-gtkhtml2", rpm:"i386/gnome-python2-gtkhtml2~2.14.2~9.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}