###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for arts FEDORA-2007-2985
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861497);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2985");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name(english: "Fedora Update for arts FEDORA-2007-2985");
  desc["english"] = "

  Vulnerability Insight:
  arts (analog real-time synthesizer) is the sound system of KDE 3.
  
  The principle of arts is to create/process sound using small modules which do
  certain tasks. These may be create a waveform (oscillators), play samples,
  filter data, add signals, perform effects like delay/flanger/chorus, or
  output the data to the soundcard.
  
  By connecting all those small modules together, you can perform complex
  tasks like simulating a mixer, generating an instrument or things like
  playing a wave file with some effects.


  Affected Software/OS:
  arts on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00328.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of arts");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"arts", rpm:"arts~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts", rpm:"arts~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts-devel", rpm:"arts-devel~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts-debuginfo", rpm:"arts-debuginfo~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts-debuginfo", rpm:"arts-debuginfo~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts", rpm:"arts~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"arts-devel", rpm:"arts-devel~1.5.8~4.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}