###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for koffice FEDORA-2007-3093
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861217);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-3093");
  script_cve_id("CVE-2007-4352", "CVE-2007-5392", "CVE-2007-5393");
  script_name(english: "Fedora Update for koffice FEDORA-2007-3093");
  desc["english"] = "

  Vulnerability Insight:
  KOffice - Integrated Office Suite
  KOffice is a free, integrated office suite for KDE, the K Desktop Environment.


  Affected Software/OS:
  koffice on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00236.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of koffice");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"koffice", rpm:"koffice~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-krita", rpm:"koffice-krita~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kword", rpm:"koffice-kword~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-karbon", rpm:"koffice-karbon~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kformula", rpm:"koffice-kformula~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kpresenter", rpm:"koffice-kpresenter~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi", rpm:"koffice-kexi~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-core", rpm:"koffice-core~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kugar", rpm:"koffice-kugar~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-libs", rpm:"koffice-libs~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-debuginfo", rpm:"koffice-debuginfo~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-suite", rpm:"koffice-suite~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kivio", rpm:"koffice-kivio~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kspread", rpm:"koffice-kspread~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi-driver-pgsql", rpm:"koffice-kexi-driver-pgsql~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kplato", rpm:"koffice-kplato~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kchart", rpm:"koffice-kchart~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi-driver-mysql", rpm:"koffice-kexi-driver-mysql~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-filters", rpm:"koffice-filters~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-devel", rpm:"koffice-devel~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-suite", rpm:"koffice-suite~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kspread", rpm:"koffice-kspread~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kchart", rpm:"koffice-kchart~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi-driver-mysql", rpm:"koffice-kexi-driver-mysql~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kpresenter", rpm:"koffice-kpresenter~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kugar", rpm:"koffice-kugar~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi-driver-pgsql", rpm:"koffice-kexi-driver-pgsql~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-libs", rpm:"koffice-libs~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kplato", rpm:"koffice-kplato~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kivio", rpm:"koffice-kivio~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kword", rpm:"koffice-kword~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kformula", rpm:"koffice-kformula~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-kexi", rpm:"koffice-kexi~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-karbon", rpm:"koffice-karbon~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-debuginfo", rpm:"koffice-debuginfo~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-filters", rpm:"koffice-filters~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-core", rpm:"koffice-core~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"koffice-krita", rpm:"koffice-krita~1.6.3~13.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}