###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for drupal-views FEDORA-2008-11519
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860186);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-11519");
  script_cve_id("");
  script_name(english: "Fedora Update for drupal-views FEDORA-2008-11519");
  desc["english"] = "

  Vulnerability Insight:
  The views module provides a flexible method for Drupal site designers
  to control how lists of content (nodes) are presented. Traditionally,
  Drupal has hard-coded most of this, particularly in how taxonomy and
  tracker lists are formatted.
  
  This tool is essentially a smart query builder that, given enough
  information, can build the proper query, execute it, and display the
  results. It has four modes, plus a special mode, and provides an
  impressive amount of functionality from these modes.


  Affected Software/OS:
  drupal-views on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg01024.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of drupal-views");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"drupal-views", rpm:"drupal-views~6.x.2.2~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}