###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for rsync FEDORA-2008-3060
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860256);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3060");
  script_cve_id("");
  script_name(english: "Fedora Update for rsync FEDORA-2008-3060");
  desc["english"] = "

  Vulnerability Insight:
  Rsync uses a reliable algorithm to bring remote and host files into
  sync very quickly. Rsync is fast because it just sends the differences
  in the files over the network instead of sending the complete
  files. Rsync is often used as a very powerful mirroring process or
  just as a more capable replacement for the rcp command. A technical
  report which describes the rsync algorithm is included in this
  package.


  Affected Software/OS:
  rsync on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00247.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rsync");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"rsync", rpm:"rsync~2.6.9~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}