###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for nagios FEDORA-2008-3098
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860595);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-3098");
  script_cve_id("CVE-2007-5198");
  script_name(english: "Fedora Update for nagios FEDORA-2008-3098");
  desc["english"] = "

  Vulnerability Insight:
  Nagios is a program that will monitor hosts and services on your
  network.  It has the ability to send email or page alerts when a
  problem arises and when a problem is resolved.  Nagios is written
  in C and is designed to run under Linux (and some other *NIX
  variants) as a background process, intermittently running checks
  on various services that you specify.
  
  The actual service checks are performed by separate &quot;plugin&quot; programs
  which return the status of the checks to Nagios. The plugins are
  available at <a  rel= &qt nofollow &qt  href= &qt http://sourceforge.net/projects/nagiosplug &qt >http://sourceforge.net/projects/nagiosplug</a>.
  
  This package provides the core program, web interface, and documentation
  files for Nagios. Development files are built as a separate package.


  Affected Software/OS:
  nagios on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-April/msg00282.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nagios");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"nagios", rpm:"nagios~2.11~3.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}