###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for neon FEDORA-2008-7661
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860392);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-7661");
  script_cve_id("CVE-2008-3746");
  script_name(english: "Fedora Update for neon FEDORA-2008-7661");
  desc["english"] = "

  Vulnerability Insight:
  neon is an HTTP and WebDAV client library, with a C interface;
  providing a high-level interface to HTTP and WebDAV methods along
  with a low-level interface for HTTP request handling.  neon
  supports persistent connections, proxy servers, basic, digest and
  Kerberos authentication, and has complete SSL support.


  Affected Software/OS:
  neon on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00367.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of neon");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"neon", rpm:"neon~0.28.3~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}