###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_graphicsmagick_detect_win.nasl 1015 2009-02-16 09:15:50Z feb $
#
# GraphicsMagick Version Detection (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800514);
  script_version("$Revision: 1.0 $");
  script_name(english:"GraphicsMagick Version Detection (Win)");
  desc["english"] = "

  Overview: This script detects the installed version of GraphicsMagick
  and sets the version in KB.

  Risk factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets KB for Version of GraphicsMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\GraphicsMagick")){
  exit(0);
}

gmVer = registry_get_sz(key:"SOFTWARE\GraphicsMagick\Current", item:"Version");
if(gmVer != NULL){
  set_kb_item(name:"GraphicsMagick/Win/Ver", value:gmVer);
}
