###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for xfs and stmkfont HPSBUX01061
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835133);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "01061");
  script_cve_id("");
  script_name(english: "HP-UX Update for xfs and stmkfont HPSBUX01061");
  desc["english"] = "

  Vulnerability Insight:
  Potential security vulnerabilities have been identified with HP-UX running 
  xfs and stmkfont. These vulnerabilities can be exploited to allow remote 
  unauthorized access to resources owned by group 'bin.' 

  Impact:
  Remote unauthorized access

  Affected Software/OS:
  xfs and stmkfont on
  HP-UX B.11.00, B.11.11, B.11.22, B.11.23 running xfs and stmkfont. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00924426-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xfs and stmkfont");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"X11.X11-FONTSRV", patch_list:['PHSS_31180'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"X11.X11-FONTSRV", patch_list:['PHSS_31181'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"X11.X11-FONTSRV", patch_list:['PHSS_31178'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"X11.X11-FONTSRV", patch_list:['PHSS_31179'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}