###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Kerberos HPSBUX02217
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835065);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02217");
  script_cve_id("CVE-2007-1216");
  script_name(english: "HP-UX Update for Kerberos HPSBUX02217");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified on HP-UX running 
  Kerberos. The vulnerability could be exploited by remote authorized users to 
  execute arbitrary code. 

  Impact:
  Remote arbitrary code execution

  Affected Software/OS:
  Kerberos on
  HP-UX B.11.11, B.11.23, and B.11.31 running the 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01056923-3

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Kerberos");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-64SLIB", patch_list:['PHSS_36361'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-IA32SLIB", patch_list:['PHSS_36361'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-IA64SLIB", patch_list:['PHSS_36361'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-SHLIB", patch_list:['PHSS_36361'], rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-64SLIB-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-E-A-MAN-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-J-E-MAN-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-J-S-MAN-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-PRG-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-RUN-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-SHLIB-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA32SLIB-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5IA64SLIB-A", revision:"D.1.3.5.06", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-64SLIB", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-ENG-A-MAN", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-IA32SLIB", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-IA64SLIB", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-JPN-E-MAN", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-JPN-S-MAN", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-PRG", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-RUN", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-SHLIB", patch_list:['PHSS_34991'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-64SLIB-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-E-A-MAN-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-J-E-MAN-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-J-S-MAN-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-PRG-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-RUN-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"krb5client.KRB5-SHLIB-A", revision:"C.1.3.5.06", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-SHLIB", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-PRG", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-RUN", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-ENG-A-MAN", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-JPN-E-MAN", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-JPN-S-MAN", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"KRB5-Client.KRB5-64SLIB", patch_list:['PHSS_36286'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}