###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for CIFS   Server (Samba) HPSBUX02218
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835087);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02218");
  script_cve_id("CVE-2007-2446", "CVE-2007-2447");
  script_name(english: "HP-UX Update for CIFS   Server (Samba) HPSBUX02218");
  desc["english"] = "

  Vulnerability Insight:
  Potential vulnerabilities have been identified with HP-UX running CIFS 
  Server (Samba). The vulnerabilities could be exploited remotely to execute 
  arbitrary code. 

  Impact:
  Remote arbitrary code execution

  Affected Software/OS:
  CIFS   Server (Samba) on
  HP-UX B.11.11, B.11.23, B.11.31 running CIFS Server (Samba) 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01067768-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of CIFS   Server (Samba)");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.02", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.02", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-ADMIN", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-DOC", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-LIB", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-MAN", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-RUN", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"CIFS-Server.CIFS-UTIL", revision:"A.02.03.02", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}