###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for OpenSSL HPSBUX02296
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835055);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "02296");
  script_cve_id("CVE-2007-4995");
  script_name(english: "HP-UX Update for OpenSSL HPSBUX02296");
  desc["english"] = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX running 
  OpenSSL. The vulnerability could be exploited remotely to execute arbitrary 
  code. 

  Impact:
  Remote execution of arbitrary code

  Affected Software/OS:
  OpenSSL on
  HP-UX B.11.11 and B.11.23 running OpenSSL before vA.00.09.07m, and B.11.31 
  running OpenSSL before vA.00.09.08g. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c01299773-4

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of OpenSSL");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.31")
{

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.08g.001", rls:"HPUX11.31"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.07m.003", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CER", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-CONF", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-INC", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-LIB", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-MIS", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PRNG", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-PVT", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"openssl.OPENSSL-RUN", revision:"A.00.09.07m.002", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}