###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_invision_power_board_xss_vuln.nasl 1347 2009-04-07 20:25:56Z apr $
#
# Invision Power Board Cross-Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800387);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6565");
  script_bugtraq_id(28466);
  script_name(english:"Invision Power Board Cross-Site Scripting Vulnerability");
  desc["english"] = "

  Overview: The host is running Invision Power Board and is prone to Cross-Site
  Scripting Vulnerability.

  Vulnerability Insight:
  Improper sanitization of user supplied input in the signature data which can
  cause crafting malicious IFRAME or HTML tags to gain sensitive information
  about the web application or can cause injection of web pages to the web
  application.

  Impact:
  Successful exploitation will let attackers execute arbitrary code in the
  context of the affected web application and can cause various web related
  attacks by point to malicious IFRAME or HTML data.

  Impact Level: Application

  Affected Software/OS:
  Invision Power Board version 2.3.1 and prior.

  Fix: Solution/Patch not available as on 09th April 2009. Information will be
  updated once the vendor supplies any updates. For further updates refer,
  http://www.invisionpower.com

  References:
  http://xforce.iss.net/xforce/xfdb/41502
  http://www.securityfocus.com/archive/1/490115

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Invision Power Board");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("invision_power_board_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ipbPort = get_kb_item("Services/www");
if(!ipbPort){
  exit(0);
}

ipbVer = get_kb_item("www/" + ipbPort + "/invision_power_board");
if(!ipbVer){
  exit(0);
}

ipbVer = eregmatch(pattern:"^(.+) under (/.*)$", string:ipbVer);
if(ipbVer[1] =~ "[0-9.]+")
{
  if(version_is_less_equal(version:ipbVer[1], test_version:"2.3.1")){
    security_warning(ipbPort);
  }
}
