###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ipsec-tools_dos_vuln.nasl 2180 2009-05-11 18:45:29Z may $
#
# IPSec Tools Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800708);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1574");
  script_name(english:"IPSec Tools Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is installed with IPSec Tools for Linux and is prone
  to Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to a NULL pointer dereference caused when the file
  'racoon/isakmp_frag.c' processes fragmented packets without any payload.

  Impact:
  Successful exploitation will let the attacker cause denial if service.

  Impact level: Application/System

  Affected Software/OS:
  IPsec Tools version prior to 0.7.2

  Fix:
  Upgrade to the latest version 0.7.2
  http://ipsec-tools.sourceforge.net

  References:
  https://bugzilla.redhat.com/show_bug.cgi?id=497990
  http://www.openwall.com/lists/oss-security/2009/05/04/3
  http://www.openwall.com/lists/oss-security/2009/04/29/6

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of IPSec Tools");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_ipsec-tools_detect.nasl");
  script_require_keys("IPSec/Tools/Ver");
  exit(0);
}


include("version_func.inc");

ipsecVer = get_kb_item("IPSec/Tools/Ver");
if(ipsecVer == NULL){
  exit(0);
}

# Grep for IPSec Tools version prior to 0.7.2
if(version_is_less(version:ipsecVer, test_version:"0.7.2")){
  security_warning(0);
}
